<?php

declare(strict_types=1);

/*
 * This file is part of the Sonata Project package.
 *
 * (c) Thomas Rabaix <thomas.rabaix@sonata-project.org>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Sonata\Form\Type;

use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * @psalm-suppress MissingTemplateParam https://github.com/phpstan/phpstan-symfony/issues/320
 *
 * @author Andrej Hudec <pulzarraider@gmail.com>
 *
 * NEXT_MAJOR: Declare the class as final.
 *
 * @final since 2.5.0.
 */
class DateTimeRangePickerType extends DateTimeRangeType
{
    public function configureOptions(OptionsResolver $resolver): void
    {
        parent::configureOptions($resolver);

        $resolver->setDefault('field_type', DateTimePickerType::class);
        $resolver->setDefault('field_options_end', [
            'datepicker_options' => [
                'useCurrent' => false,
            ],
        ]);
    }

    public function getBlockPrefix(): string
    {
        return 'sonata_type_datetime_range_picker';
    }
}
