<?php

declare(strict_types=1);

namespace League\Bundle\OAuth2ServerBundle\DBAL\Type;

use League\Bundle\OAuth2ServerBundle\ValueObject\RedirectUri as RedirectUriModel;

/**
 * @template-extends ImplodedArray<RedirectUriModel>
 */
final class RedirectUri extends ImplodedArray
{
    /**
     * @var string
     */
    private const NAME = 'oauth2_redirect_uri';

    public function getName(): string
    {
        return self::NAME;
    }

    /**
     * @param list<non-empty-string> $values
     *
     * @return list<RedirectUriModel>
     */
    protected function convertDatabaseValues(array $values): array
    {
        return array_map(static function (string $value): RedirectUriModel {
            return new RedirectUriModel($value);
        }, $values);
    }
}
